#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("ggplot2")


#library packages
library(limma)
library(Rtsne)
library(ggplot2)

expFile="metabolismGeneExp.txt"         #expression data file
clusterFile="metabolismcluster.txt"     #Typing result file
setwd("D:\\metabolism\\LGG\\6.PCA_tSNE")      

#Read the input file and organize the input file
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]
data=t(data)

#PCA analysis
data.pca=prcomp(data, scale. = TRUE)
pcaPredict=predict(data.pca)
write.table(pcaPredict, file="newTab.xls", quote=F, sep="\t")

#Read typing file
cluster=read.table(clusterFile, header=T, sep="\t", check.names=F, row.names=1)
metabolismcluster=as.vector(cluster[,1])

#set color
bioCol=c("#237AB6","#FA8415","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
metabolismCluCol=bioCol[1:length(levels(factor(metabolismcluster)))]

#visualization
PCA=data.frame(PC1=pcaPredict[,1], PC2=pcaPredict[,2], metabolismcluster=metabolismcluster)
PCA.mean=aggregate(PCA[,1:2], list(metabolismcluster=PCA$metabolismcluster), mean)
pdf(file="PCA.pdf", width=6.5, height=5)
ggplot(data = PCA, aes(PC1, PC2)) + geom_point(aes(color = metabolismcluster)) +
	scale_colour_manual(name="metabolismcluster", values =metabolismCluCol)+
    theme_bw()+
    theme(plot.margin=unit(rep(1.5,4),'lines'))+
    annotate("text",x=PCA.mean$PC1, y=PCA.mean$PC2, label=PCA.mean$metabolismcluster, cex=7)+
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
dev.off()

#t-SNE
tsneOut=Rtsne(data, dims=2, perplexity=10, verbose=F, max_iter=500,check_duplicates=F)
tsne=data.frame(tSNE1 = tsneOut$Y[,1], tSNE2 = tsneOut$Y[,2],risk=metabolismcluster)	
#plot
pdf(file="t-SNE.pdf", height=5, width=6.5)       #save
p=ggplot(data = tsne, aes(tSNE1, tSNE2)) + geom_point(aes(color = risk)) +
  scale_colour_manual(name="metabolismcluster",  values =c("#237AB6","#FA8415"))+
  theme_bw()+
  theme(plot.margin=unit(rep(1.5,4),'lines'))+
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
print(p)
dev.off()
